#include "virge.h"

#ifndef O_NOFOLLOW
#define O_NOFOLLOW     0
#endif

/*
 * procmail_deliver(mailFile,aParam,direct_deliver)
 * 
 * Deliver mail.
 * 
 * Content of mailFile is sent to procmail (through pipe) for local delivery
 *
 * mailFile = file that contains message
 * aParam = -a param, as received from Sendmail
 * direct_delivery = 'Flag' that tells if mail has been delivered 'directly' with no virus checking
 *
 * Return 0 on success, -1 if delivery failed.
 */
int procmail_deliver(const char *mailFile, char *aParam)
{
    char sendbuf[V_BUFSIZE];
    char elapsed_time[64];
    int bread;
    int mailfd;
    time_t VIRGE_END_TIME;
    FILE *procmail;
    int r = 0, rtr;

    if (!(mailfd = open(mailFile, O_RDONLY | O_NOFOLLOW)))
    {
	virge_debug(2, "[ virge_deliver() ] failed to open mailfile (%s)", mailFile);
	syslog(LOG_INFO,"FAILURE: Error occured while open()-ing mail file in virge_deliver()");
	return(-1);
    }

    virge_debug(3, "[ virge_deliver() ] Mailfile (message) to be delivered (%s) - open()ed", mailFile);

    /* Run the MDA. */
    if (!(procmail = run_program(RUN_WRITE, PROCMAIL, PROCMAIL_ARGS,
			"from", RUN_STRING, MAIL_FROM,
			"to", RUN_VLIST, RCPT_TOS,
			"aparam", RUN_STRING, aParam,
			0)))
    {
		close(mailfd);
		return(-1);
    }

    /* Read email and pass it to the MDA. */
    while ((bread = read(mailfd, sendbuf, sizeof(sendbuf))) > 0)
    {
		if (!fwrite(sendbuf, bread, 1, procmail))
		{
		    /* Check why fwrite failed. */
		    if (ferror(procmail) != 0)
		    {
				event_log(LOG_ERROR, "Error writing email to MDA");
				r = -1;
				break;
		    }
		    else
		    {
				/* We've lost the connection to the MDA.
				 * Not all the email content has been written. */
				event_log(LOG_ERROR, "MDA died prematurely");
				r = -1;
				break;
		    }
		}
    }

    /* Check if read()'ing email from stdin failed. */
    if (bread == -1)
    {
		event_log(LOG_ERROR, "Reading email: %s", strerror(errno));
		r = -1;
    }

    /* Close everything we've opened. */
    fclose(procmail);
    close(mailfd);

    virge_debug(3, "[ virge_deliver() ] procmail pipe closed, as is mailfd descriptor");

    /* We've to call run_terminate() before return()'ing, otherwise the process
     * running the MDA may become a zombie. */
    rtr = run_terminate();

    /* Check if something failed. */
    if (r)
		return(-1);

    /* Check the MDA exit code. */
    if (rtr)
    {
		event_log(LOG_ERROR, "MDA failed");
		return(rtr);
    }

    VIRGE_END_TIME = time(NULL);
    snprintf(elapsed_time, sizeof(elapsed_time), "(%.02lu:%.02lu)", (unsigned long) (VIRGE_END_TIME - VIRGE_START_TIME) / 60, (unsigned long) VIRGE_END_TIME - VIRGE_START_TIME);
		
    /*
      [-] = delivered immediately/directly - no checking
      [+] = delivered after checks have been performed
      [!] = delivered after message has been rewritten
    */
	if (rewrite_filename[0] != '\0')
		event_log(LOG_VIRGE, "Mail delivered %s [!] from=<%s>, to=<%s>, size=<%lu bytes>", elapsed_time, MAIL_FROM, RCPT_TO, V_MAIL_SIZE);
	else if (sections > 1)
		event_log(LOG_VIRGE, "Mail delivered %s [+] from=<%s>, to=<%s>, size=<%lu bytes>" , elapsed_time, MAIL_FROM, RCPT_TO, V_MAIL_SIZE);
	else
		event_log(LOG_VIRGE, "Mail delivered %s [-] from=<%s>, to=<%s>, size=<%lu bytes>", elapsed_time, MAIL_FROM, RCPT_TO, V_MAIL_SIZE);

    virge_debug(1, "[ virge_deliver() ] mail delivered from '%s' to '%s' - size: [%lu bytes] - time: [%s]", MAIL_FROM, RCPT_TO, V_MAIL_SIZE, elapsed_time);

    return(rtr);
}
