#include "virge.h"
#include <assert.h>
#ifndef O_NOFOLLOW
#define O_NOFOLLOW     0400000
#endif



/*
  Sends secret message to alien force preparing to ... oh shit, wrong one...
  
  src = source
  dst = destination
  
  Example:
  
  copyFile("c:\pagefile.sys", "c:\winnt\system32\kernel32.dll")
*/  
int copyFile(char *src, char *dst)
{
    char fileOut[MAXPATHLEN];
    char fileBuf[V_BUFSIZE];
    int fileRead;
    unsigned long octal_mode = 0;
    int fin;
    int fout;
    int r = 0;

    /* Check if fileOut has enough room for the filename. */
    if (strlen(dst) + strlen(V_MAILBODY) + 1 >= sizeof(fileOut))
    {
	/* Even if you increase fileOut in this case, the open call below would fail. */
	event_log(LOG_ERROR, "FIXME: fileOut's too small");
	return(-1);
    }

    /* Make filename of the isolated file. */
    sprintf(fileOut, "%s/%s", dst, V_MAILBODY);

    virge_debug(3, "[ copyFile() ] Output filename = '%s'", fileOut);

    /* Open the source file. */
    if (!(fin = open(src, O_RDONLY | O_NOFOLLOW)))
    {
		event_log(LOG_ERROR, "Failed opening source file (%s): %s", src, strerror(errno));
		return(-1);
    }

    /* Set the file permissions */
    /* If mode is not set - set it to 00600 */
    if (ISOLATED_FILE_MODE[0] == '\0')
    {
		/* ISOLATED_FILE_MODE = "00600"; */
		octal_mode = 0600;
    }
    else
    {
		octal_mode = strtoul(ISOLATED_FILE_MODE, NULL, 8);
    }

    /* Open the destination file. */
    if (! (fout = open(fileOut, O_WRONLY | O_CREAT | O_NOFOLLOW, octal_mode)))
    {
		event_log(LOG_ERROR, "Failed opening destination file (%s): %s",
			fileOut,
			strerror(errno));

		close(fin);
		return(-1);
    }

    /* Copy all data from fin into fout. */
    while((fileRead = read(fin, fileBuf, sizeof(fileBuf))) > 0)
    {
		if ( (r = write(fout, fileBuf, fileRead)) == -1)
		{
		    event_log(LOG_ERROR, "Writing to isolated file: %s", strerror(errno));
		    break;
		}
		else if (r != fileRead)
		{
		    event_log(LOG_ERROR, "Writing to isolated file: Partial write");
		    r = -1;
		    break;
		}
    }

    /* Check for error reading. */
    if (fileRead == -1)
    {
		event_log(LOG_ERROR, "Reading email file: %s", strerror(errno));
		r = -1;
    }

    /* If the isolated file is on a NFS partition, close will be used to report errors. */
    if (close(fout) == -1 && r != -1)
    {
		event_log(LOG_ERROR, "Closing isolated file: %s", strerror(errno));
		r = -1;
    }

    /* fin is just read, no need to check for errors here. */
    close(fin);

    virge_debug(1, "[ copyFile() ] copied from '%s' to '%s'", src, fileOut);

    return(r == -1 ? -1 : 0);
}

/*
 *   Isolates (makes a copy of mailbody/message) offending message (leaves porn intact though! ;)
 *
 * Look below for more details.
 */
int isolate(int type, char *isoComment, char *isoFile, int isoNotify, char *isoNotifyMsg)
{
    FILE *f = 0;
    char isoDir[MAXPATHLEN];


    /* type:
     *    (it's not used now, but I never know if some of these 'options' will
     * require some additional tasks to be performed)
     * 
     * 0 = isolate because of virus
     * 1 = isolate because of 'dodgy' attachment(s)
     * 2 = isolate because of something else
     * 3 = isolate because procmail() was dead/errored!? "queue" it? or something... TODO
     * 
     * isoComment: comment (will be logged)
     * isoFile: tempfile (mailbody is stored there) which we'll isolate
     * isoDir: directory where file will be saved (isolated)
     * isoNotify: should the admin be notified?
     * isoNotifyMsg: text for the notification message
     */

    mkdir_isolate(isoDir,sizeof(isoDir));


    virge_debug(4, "[ isolate() ] invoked as:\n\
       TYPE : [%d]\n\
       FROM : [%s]\n\
         TO : [%s]\n\
    COMMENT : [%s]\n\
   MAILFILE : [%s]\n\
STORAGE_DIR : [%s]\n\
     NOTIFY : [%d]\n\
 NOTIFY_MSG : [%s]\n\
 MESSAGE ID : [%s]", type, MAIL_FROM, RCPT_TO, isoComment, isoFile, isoDir, isoNotify, isoNotifyMsg, messageID);

   /* If SAVE_ISOLATED is not 1, virus/attachment WILL NOT BE SAVED! Make sure you know what you're doing */
	switch(type)
	{
		case 0:
	    /* virus */
	    /* Notify sender or recepient if necessary */
		/* Don't return/exit it this fails */
	    if (NOTIFY_SENDER_VIRUS)
			notify_sender(NOTIFY_VIRUS_FOUND);
	    if (NOTIFY_RCPT_VIRUS)
			notify_rcpt(NOTIFY_VIRUS_FOUND);

		/* Should file be 'isolated' */
		if (SAVE_ISOLATED)
		{
		    if (copyFile(isoFile, isoDir) == -1)
				return(-1);

		    event_log(LOG_ACTION,"Mail (virus: %s) from '%s' to '%s' has been isolated in [%s/%s]",
			      VIRUS_NAME[0] ? VIRUS_NAME : "??",
			      MAIL_FROM, RCPT_TO, isoDir, V_MAILBODY);
	    
		    virge_debug(1, "[ isolate() ] virus from '%s' to '%s' has been isolated in '%s/%s'", MAIL_FROM, RCPT_TO, isoDir, V_MAILBODY);
	    }
	    break;

		case 1:
	    /* attachments */
	    /* Send notification to sender - if needed */
	    if (NOTIFY_SENDER_ATTACHMENT)
			notify_sender(NOTIFY_BAD_ATTACHMENTS);
	    if (NOTIFY_RCPT_VIRUS)
			notify_rcpt(NOTIFY_BAD_ATTACHMENTS);

	    if (SAVE_ISOLATED)
		{
			if (copyFile(isoFile, isoDir) == -1)
			return(-1);

		    event_log(LOG_ACTION,"Mail from '%s' to '%s' has been isolated (forbidden attachment(s)) in [%s/%s]",
			      MAIL_FROM, RCPT_TO, isoDir, V_MAILBODY);
		    virge_debug(1, "[ isolate() ] mail from '%s' to '%s' with forbidden attachment(s) has been isolated in '%s/%s'",
				MAIL_FROM, RCPT_TO, isoDir, V_MAILBODY);
		}
		break;

		default:
	    /* This must be something else then (type 2), or something 'unknown' (which shouldn't happen :) */
	    /* We copy the mail message (body) to the isolation directory */
	    copyFile(isoFile, isoDir);
	    /* We generate a string that's going to the log */
	    event_log(LOG_ACTION,"Mail from '%s' to '%s' has been isolated in [%s/%s]", MAIL_FROM, RCPT_TO, isoDir, V_MAILBODY);
	    virge_debug(1, "[ isolate() ] mail from '%s' to '%s' has been isolated in '%s/%s'", MAIL_FROM, RCPT_TO, isoDir, V_MAILBODY);
	}

	if (!SAVE_ISOLATED)
	{
		event_log(LOG_ACTION, "Mail from '%s' to '%s' has NOT BEEN ISOLATED, although it contained forbidden attachment(s) or virus(es)",
			MAIL_FROM, RCPT_TO);
    }

    /* Send a mail to admin now... if isoNotify == 1 */
    if (isoNotify)
    {
	if (! (f = virge_openmail(ADMIN, "VIRGE NOTIFICATION",0)))
	    return(-1);

	fprintf(f,"NOTICE     : %s\n",isoNotifyMsg);
	fprintf(f,"MAIL FROM  : %s\n",MAIL_FROM);
	fprintf(f,"RCPT TO    : %s\n",RCPT_TO);
	fprintf(f,"HEADER TO  : %s\n",NOTIFY_TO ? NOTIFY_TO : "(not found in headers)");
	fprintf(f,"SUBJECT    : %s\n",NOTIFY_SUBJECT);
	fprintf(f,"DATE       : %s\n",NOTIFY_DATE);
	fprintf(f,"MESSAGE ID : %s\n",messageID);
	fprintf(f,"ISOLATED   : %s\n",isoDir);

	/* If we have virus name - append it to the message */
	if (VIRUS_NAME[0] != '\0') fprintf(f,"VIRUS      : %s\n",VIRUS_NAME);

	if (vlist_count(REMOVED)){
	    notify_removed_attachments(f);
	}
		
	if (virge_closemail(f) == -1)
	    return(-1);

	virge_debug(1, "[ isolate() ] notification sent to administrator");
    }

    return(0);
}


/*
  Creates a dir. Wow
  
  newdir = path
  
  Example:
  
  virge_mkdir("/tmp/virge_tmpdir");
*/
int virge_mkdir(char *newdir)
{
    unsigned dir_octal_mode;
    dir_octal_mode = strtoul(VIRGE_DIR_MODE, NULL, 8);
	
    if (mkdir(newdir, dir_octal_mode))	{
	virge_debug(2, "[ virge_mkdir() ] failed to create directory '%s'", newdir);
	syslog(LOG_INFO,"FAILURE: Failed to create directory '%s' in virge_mkdir()", newdir);
	return 0;
    }

    virge_debug(1, "[ virge_mkdir() ] created directory '%s'", newdir);
    return 1;
}

/*
 * Checks if the path exists and is a directory.
 *
 * check_directory(path,int *owner)
 * checkFile = path to check
 *
 * Example:
 *
 * check_directory("/3/years/without/remote/hole/blah/blah/blah/");
 */
int check_directory(const char *checkFile, uid_t *uid)
{
    struct stat fileBuf;
    
    virge_debug(1, "[ check_directory() ] checkFile='%s'", checkFile);

    if(stat(checkFile, &fileBuf) == 0)
	{
		if (uid)
			*uid = fileBuf.st_uid;

		if (S_ISDIR(fileBuf.st_mode))
		{
		    /* Ok, we've got a dir */
		    virge_debug(2, "[ check_directory() ] directory exists.");
		    return 1;
		}
    }

    virge_debug(2, "[ check_directory() ] directory does not exist.");
    return 0;			/* does not exist */
}

/*
 * demand_directory(path)
 * Make sure the directory exists and is owned by virge.
 * If it doesn't, make it.
 * Note: we create the directory first but don't bother checking the return code.
 * If we fail, we exit
 */

void demand_directory(const char *path,const char *dirType)
{
    FILE *f;
    uid_t uid = 0;
    
    mkdir(path,0777);

    if (check_directory(path, &uid))
	{
		struct passwd *runasUser = getpwnam(RUNAS_USER);
		if(uid != runasUser->pw_uid)
		    chown(path, runasUser->pw_uid, runasUser->pw_gid);

		return;
    }

    /* Complain REALLY LOUDLY if we can't create a directory */
    event_log(LOG_ERROR,"Could not create or access directory '%s' (%s)",path,dirType);

    syslog(LOG_INFO,"FATAL ERROR: COULD NOT CREATE %s DIRECTORY ('%s') FOR VIRGE!",
	   dirType,path);
    syslog(LOG_INFO,"FATAL ERROR: NO %s DIRECTORY - NO MAIL DELIVERY! FIX THE PROBLEM",
	   dirType);

    /* Either send email to the admin or print the message */
    f = INTERACTIVE ? stderr : virge_openmail(ADMIN,"ERROR NOTIFICATION",0);

    fprintf(f,"--\n");
    fprintf(f,"* URGENT!\n");
    fprintf(f,"* VIRGE %s DIRECTORY ('%s') COULD NOT BE CREATED!\n",dirType,path);
    fprintf(f,"* PLEASE, FIX THIS PROBLEM!\n");
    fprintf(f,"--\n");
    
    if(!INTERACTIVE)
		virge_closemail(f);

    /* Now bomb out */
    assert(0);
}

/*
  Returns a name for directory (could be file, could be whatever), containing today's date - how clever, eh?
*/
char *get_date_dir(char *ddir)
{
	struct tm *timestamp;
	time_t tt;
/*	char blah[24]; */
/*	memset(blah, 0, sizeof(blah)); */

	tt = time(NULL);
	timestamp = localtime(&tt);

	strftime(ddir, 16, "%Y-%m-%d", timestamp);

    virge_debug(1, "[ get_date_dir() ] ddir = '%s'", ddir);
    return ddir;
}

/*
 * Creates a directory where offending mail is going to be archived
 */
char *mkdir_isolate(char *isolateDir,int dirlen)
{
    char datedir[MAXPATHLEN];
    char modDir[MAXPATHLEN];
	
    if (SAVE_ISOLATED == 0){
	strncpy(isolateDir,"<ISOLATED FILE NOT PRESERVED (save_isolated=0)>",dirlen);
	return isolateDir;
    }
	
    /* Damn - is this right!? */
    strncpy(isolateDir, V_ISODIR, dirlen-1);
    isolateDir[dirlen-1] = '\0';

    /* The RCPT_TO directory comes next */
    snprintf(modDir, sizeof(modDir)-1, "%s/%s", isolateDir, RCPT_TO);
    strncpy(isolateDir, modDir, dirlen-1);
    isolateDir[dirlen-1] = '\0';
    virge_debug(3, "[ mkdir_isolate() ] dir to create: '%s'", isolateDir);

    /* Create user directory */
    demand_directory(isolateDir,"Isolate dir");

    /* The date directory comes next */
    snprintf(modDir, sizeof(modDir), "%s/%s", isolateDir, get_date_dir(datedir));
    strncpy(isolateDir, modDir, dirlen-1);
    isolateDir[dirlen-1] = '\0';
    virge_debug(3, "[ mkdir_isolate() ] dir to create: '%s'", isolateDir);

    /* Create date directory */
    demand_directory(isolateDir,"Isolate dir");

    /* The messageID directory comes next */
    snprintf(modDir, sizeof(modDir), "%s/%s", isolateDir, messageID);
    strncpy(isolateDir, modDir, dirlen-1);
    isolateDir[dirlen-1] = '\0';
    virge_debug(3, "[ mkdir_isolate() ] isolation dir to create: '%s'", isolateDir);

    /* Create date directory */
    demand_directory(isolateDir,"Isolate dir");

    virge_debug(1, "[ mkdir_isolate() ] isolation dir created: '%s'", isolateDir);
    return isolateDir;
}

/*
 *  Removes temporary directory. How cool.
 *  
 *  Example:
 *  
 *   remove_tempdir("/tmp/virge_tmp/");
 */
void remove_tempdir(char *removeDir)
{
    struct dirent *dir_contents;
    DIR *dir;

    /* Let's chdir() into the dir - and do the dirty stuff there - lame, but makes me feel better */
    chdir(removeDir);
	
    /* Open the directory */
    if (!(dir = opendir(removeDir)))
	{
	    syslog(LOG_INFO,"FAILURE: opendir() failed for '%s's", removeDir);
	    return;
	}
	
    /* Go through filelist and remove them */
    for (dir_contents = readdir(dir) ; dir_contents != NULL ; dir_contents = readdir(dir))
	{
	    /* This needs to be rewritten probably... */
	    if ( (strcmp(dir_contents->d_name,".")) && (strcmp(dir_contents->d_name,"..")) )
		{
		    if ((unlink(dir_contents->d_name)) == -1)
			{
			    virge_debug(2, "[ remove_tempdir() ] failed to unlink() '%s'", dir_contents->d_name);
			    syslog(LOG_INFO,"FAILURE: unlink() failed in remove_tempdir() - dir: '%s', file: '%s'", removeDir, dir_contents->d_name);
			}
		    else
			{
			    virge_debug(3, "[ remove_tempdir() ] removed '%s'", dir_contents->d_name);
			}
				
		}
	}

    /* Step back, please... */
    chdir("..");
		
    if (rmdir(removeDir) == -1)
	{
	    event_log(LOG_ERROR, "FAILURE: Could not remove directory '%s'", removeDir);
	}
    else
	{
	    virge_debug(1, "[ remove_tempdir() ] removed dir '%s'", removeDir);
	}
}

/* Checks if the file exists */
int file_exists(char *check_if_exists)
{
    if (access(check_if_exists, F_OK) == -1)
	return(0);

    return(1);
	
}

/* Get "Date:" and "Subject:" headers from the mail
 * SLG: This is pretty twisted. I think he is trying to handle
 * continuation lines.
 **/
void get_headers(FILE *hfp)
{
    char found_date[V_BUFSIZE];
	
    memset(found_date, 0, sizeof(found_date));

    fseek(hfp,0,SEEK_SET);

    while(!feof(hfp)){
	char temp_line[V_BUFSIZE];
	char *eol = 0;

	memset(temp_line, 0, sizeof(temp_line));
	if ((fgets(temp_line, sizeof(temp_line)-1, hfp)) == NULL){
	    break;
	}
	eol = strchr(temp_line,'\n');
	if(eol) *eol = '\000';		/* chomp */

	eol = strchr(temp_line,'\r');
	if(eol) *eol = '\000';		/* chomp */

	if(temp_line[0]=='\000') break;	/* end of the header */

	if ((strncasecmp(temp_line, "Date: ", 6)) == 0) {
	    NOTIFY_DATE = strdup(temp_line+6);
	    virge_debug(3, "[ get_headers() ] Got date line (%s)", NOTIFY_DATE);
	    continue;
	}

	/* If we find a 'From ' header, grab the date */
	if ((strncasecmp(temp_line, "From ", 5)) == 0) {
	    char *chop_from_date;

	    chop_from_date = strstr(temp_line," ");
	    if(chop_from_date && strlen(chop_from_date)>2){
		chop_from_date += 2;
		strncpy(found_date, chop_from_date, sizeof(found_date)-1);
		virge_debug(3, "[ get_headers() ] Got \"From ...\" header - got date (%s)", found_date);
	    }
	    else {
		virge_debug(2, "[ get_headers() ] Got from header (%s), but date seems to be missing.", temp_line);
	    }
	}
			
	/* Get "To: " header */
	if ((strncasecmp(temp_line, "To:", 3)) == 0){
	    NOTIFY_TO = strdup(temp_line+3);
	    while(*NOTIFY_TO && isspace(*NOTIFY_TO)){
		NOTIFY_TO++;		/* remove leading whitespace; we will never free this */
	    }
	    virge_debug(3, "[ get_headers() ] Got chopped \"To:\" header (%s)", NOTIFY_TO);
	}

	/* Get "Subject: " header */
	if ((strncasecmp(temp_line, "Subject:", 8)) == 0) {
	    NOTIFY_SUBJECT = strdup(temp_line+8);
	    while(*NOTIFY_SUBJECT && isspace(*NOTIFY_SUBJECT)){
		NOTIFY_SUBJECT++;		/* remove leading whitespace; we will never free this */
	    }
	    virge_debug(3, "[ get_headers() ] Got chopped \"Subject:\" header (%s)", NOTIFY_SUBJECT);
	}
    }
    fseek(hfp,0,SEEK_SET);
	
    /* If we did not get a NOTIFY_DATE, see if there was a found_date */
    if (NOTIFY_DATE[0] == '\0') {
	if (found_date[0] == '\0') {
	    virge_debug(2, "[ get_headers() ] found_date and NOTIFY_DATE empty. Setting NOTIFY_DATE = \"UNKNOWN\".");
	    syslog(LOG_INFO,"NOTE: Could not get a date for mail - [%s] => [%s] - ID: [%s]",
		   MAIL_FROM, RCPT_TO, messageID);
	    NOTIFY_DATE = "UNKNOWN";
	}
	else {
	    char buf[1024];
	    virge_debug(2, "[ get_headers() ] Setting NOTIFY_DATE to found_date (%s).", found_date);
	    sprintf(buf,"Date: %s", found_date);
	    NOTIFY_DATE = strdup(buf);
	}
    }
	
    /* In case "Subject:" header was not found - improvize ;) */
    if (NOTIFY_SUBJECT[0] == '\0') {
	NOTIFY_SUBJECT = "(UNKNOWN)";
    }

    /* In case "To:" header was not found, put the RCPT_TO into NOTIFY_TO */
    if (NOTIFY_TO[0] == '\0') {
	NOTIFY_TO= malloc(strlen(RCPT_TO)+16);
	strcpy(NOTIFY_TO,RCPT_TO);
	strcat(NOTIFY_TO," (*)");
    }
}

