/*
 * virge_loadavg.c:
 *
 * Calculate the load average.
 */

#include "virge.h"

#if (defined(BSDSTYLE) || defined(SOLARIS))
/* Check the average load on the machine (FreeBSD - possibly others & Slowaris?) */
int check_loadavg(void)
{
	double load_avg[1];
	int loadret;
	
	if (!(loadret = getloadavg(load_avg, 1)))
	{
		virge_debug(3, "[ check_loadavg() ] getloadavg() failed!");
		return(99);
	}

	virge_debug(3, "[ check_loadavg() ] loadavg obtained [%f] - returning", load_avg[0]);
	return (int)load_avg[0];
}
#endif

#ifdef HPUX
/* "Stolen" from Emacs code */
int check_loadavg(void)
{
	struct pst_dynamic procinfo;
	union pstun statbuf;
	
	double load_avg[1];
	
	statbuf.pst_dynamic = &procinfo;

	if (pstat(PSTAT_DYNAMIC, statbuf, sizeof (struct pst_dynamic), 0, 0) == -1)
	{
		virge_debug(3, "[ check_loadavg() ] pstat() failed!");
		return (99);
	}
	
	load_avg[0] = procinfo.psd_avg_1_min;
	
	virge_debug(3, "[ check_loadavg() ] loadavg obtained [%f] - returning", load_avg[0]);
	return (int)load_avg[0];
}
#endif

#ifdef LINUX
/* Check the average load on the machine (LINUX) */
int check_loadavg(void)
{
	FILE *floadavg;
	char load_avg[16];
	int l;
	int lPos = 0;

	if (!(floadavg = fopen(PROC_LOADAVG, "r")))
	{
		/* This can actually happen (happened just few mins ago, when there were 317 sendmail processes, when "find / -type f -exec ls -la {} \;" was also running, and mysql/apache and other things were active too :) */
		event_log(LOG_ERROR, "Could not open '%s' to check average load", PROC_LOADAVG);

		/* Holy shit - I was exit()ing here before if load couldn't be checked. I am a moron... (mail would get lost!!!) */
		/* If we can't check load, we'll assume it's *high* (it happened to me :) */
		return(99);
	}
	
	load_avg[0] = '\0';

	/*
	 * We only need 'leading' digit(s), before the dot
	 * 
	 * For example, it looks like:
	 *
	 * 0.00 0.03 0.00 2/55 13065
	 * 
	 * but it can also be
	 * 
	 * 3.25 2.63 1.45 2/56 13065
	 * 
	 * We can not take only 1 character, since load might be 12.xx as well
	 */
	while ( (l = fgetc(floadavg)) != '.') {
	    /*
	     * If anything ever gets wrong, and it continues to read more than
	     * 16 bytes - we're screwed .
	     Let's not allow that...
	    */
	    if (lPos >= 15)
		break;
	    else
		sprintf(&load_avg[lPos++], "%c", l);
	}

	fclose(floadavg);

	virge_debug(3, "[ check_loadavg() ] loadavg obtained [%s] - returning", load_avg);

	return(atoi(load_avg));
}
#endif

#ifdef AIX
/* Do not check the average load on the machine (AIX), as it would require
 opening /dev/kmem and thus special privileges (FIXME) */
int check_loadavg(void)
{
	return(0);
}
#endif
