#include "virge.h"
#ifndef O_NOFOLLOW
#define O_NOFOLLOW     0400000
#endif

char *get_timestamp(void)
{
	char *ts = NULL;
	char *p;
	struct tm *timestamp;
	time_t tt;
	char timedatestamp[24];

	memset(timedatestamp, 0, sizeof(timedatestamp));
	tt = time(NULL);
	timestamp = localtime(&tt);

	strftime(timedatestamp, sizeof(timedatestamp)-1, "[%Y-%m-%d %T] ", timestamp);

/*	printf("stamp: [%s]\n", timedatestamp); */

	ts = strdup(timedatestamp);
	p = ts + strlen(timedatestamp);
	*p = '\0';
	return(ts);
}

/*
 * Sends debug messages to stderr or syslog (1 = stderr, 2 = syslog)
 * If logging to syslog and stdin is a tty, log to both
 */  
void virge_debug(int debugLevel, char *debugMessage, ...)
{
    char debugString[V_LOGMSG];
    char debugFinal[V_LOGMSG];
    int debugFile;
	char *ts;

    va_list argptr;

    if (debugLevel > DEBUG_LEVEL)
		return;

    /* Create string */
    va_start(argptr, debugMessage);
    vsnprintf(debugString, sizeof(debugString)-1, debugMessage, argptr);
    va_end(argptr);

	ts = get_timestamp();

    snprintf(debugFinal, V_LOGMSG-1, "%s%s%s[%d]: %s\n",
	     messageID[0] ? "[" : "",
	     messageID,
	     messageID[0] ? "] " : "",
	     debugLevel, debugString);

    if(V_TEST || INTERACTIVE)
	{
		fprintf(stderr,"%s%s", ts, debugFinal);
		return;
    }

    if (DEBUG_OUTPUT & 0x01)
	{
		if ((debugFile = open(LOG_VDEBUG, O_CREAT | O_RDWR | O_NOFOLLOW | O_APPEND, 0600)) != -1)
		{
		    /* Locking was removed, because write() is automic. */
			write(debugFile, ts, strlen(ts));
		    write(debugFile, debugFinal, strlen(debugFinal));
		    close(debugFile);
		}
		else
		{
		    syslog(LOG_ERR,"FAILURE: Could not open debugging logfile '%s' for writing: %s ", LOG_VDEBUG,strerror(errno));
		}
    }

    if (DEBUG_OUTPUT & 0x02)
		syslog(LOG_INFO,"%s",debugFinal);
}

/*
 * Logs message to virge logfile
 *
 * logPath = LOG_VIRGE / LOG_ERROR / LOG_ACTION
 * logMessage = formatted string (message to be logged)
 * 
 * Example:
 * 
 * event_log(LOG_ACTION, "User '%s' is probably spamming user '%s' - remember to crash their mail server",
 *           MAIL_FROM, RCPT_TO);
 */
int event_log(char *logPath, char *logMessage, ...)
{
    char logString[V_LOGMSG];
    char logFinal[V_LOGMSG];
    int	logFile;

	char *ts; /* timestamp */

    /* l_type   l_whence  l_start  l_len  l_pid   */
    struct flock lock = { F_WRLCK, SEEK_SET, 0, 0, 0 };

    va_list argptr;
    va_start(argptr, logMessage);
    vsnprintf(logString, sizeof(logString)-1, logMessage, argptr);
    va_end(argptr);

    snprintf(logFinal, V_LOGMSG-1, "%s: %s\n", messageID, logString);

	/* Get time/date */
	ts = get_timestamp();

    /* Log to syslog if file can't be opened... */
    if ((logFile = open(logPath, O_CREAT | O_RDWR | O_NOFOLLOW | O_APPEND, 0600)) == -1)
	{
		virge_debug(1, "[ event_log() ] failed to open logfile (%s)", logPath);
		syslog(LOG_INFO,"FAILURE: Could not open logfile '%s' for writing", logPath);
		syslog(LOG_INFO,"%s",logFinal);
    }
    else
	{
		lock.l_pid = getpid();

		/*
		 * Ups... On Linux, it never returns -1, it just - waits...
		 * - Linux (seems to work ok)
		 * - HP-UX 10.20 (seems to work ok)
		 * - will try others when I get more free time...
		 */
		fcntl(logFile, F_SETLKW, &lock);

		/* Ok, lock has hopefully been set */
		write(logFile, ts, strlen(ts));
		write(logFile, logFinal, strlen(logFinal));
		lock.l_type = F_UNLCK;
		fcntl(logFile, F_SETLK, &lock);
		close(logFile);
    }

    /* In some cases, we always want to log to syslog */
    if(logPath == LOG_ERROR)
	{
		/* Log to debug and syslog for errors */
		syslog(LOG_INFO,"VIRGE ERROR: %s",logFinal);
    }

    if(logPath == LOG_ACTION)
		syslog(LOG_INFO,"VIRGE ACTION: %s",logFinal);

    /* Finally, log to debug */
	/* We'll remove the newline - lame but bit more readable ;) */
	if (strchr(logFinal, '\n'))
		*strchr(logFinal, '\n') = '\000';

	/* Ouch! Don't think this will remain here for a long time... */
    virge_debug(1, "[ event_log() ] %s", logFinal + (strlen(messageID)) + 2);

    return 0;
}


