#include "virge.h"

/*
  Scans a path with AVP, and returns the result
  
  scanpath = path on *local* hard disk where attachments are unpacked
  
  No, you can not scan a file on your remote WinNT based file server in another country using this function.
  
  Example:
  
  scan_avp(scratch_dir);
*/  
int scan_avp(const char *scanpath)
{
	int avp;
	int conn;
	int msglen;
	int resp = 0;
	int exitcode;
	int readrecv;

	char *response;
	char *tempresp;
	char scan[512];
	time_t nowtime;
	struct sockaddr_un avp_sock;

	memset(&avp_sock, 0, sizeof(avp_sock));
	avp_sock.sun_family=AF_UNIX;
	strcpy(avp_sock.sun_path, "/var/run/AvpCtl\0\0\0");
	
	if ( (avp = socket(AF_UNIX,SOCK_STREAM,0)) <0)
	{
		virge_debug(2, "[ scan_avp() ] failed to create UNIX socket to AVP");
		syslog(LOG_INFO,"FAILURE: Failed to create a socket in scan_avp()");
		return(-1);
	}

	conn = connect(avp, (struct sockaddr *) &avp_sock, sizeof(avp_sock.sun_family)+strlen("/var/run/AvpCtl"));
	if (conn == -1)
	{
		virge_debug(2, "[ scan_avp() ] failed to connect to AVP using connect()");
		syslog(LOG_INFO,"FAILURE: Failed to connect to AVPDaemon in scan_avp()");
		return(-1);
	}

	/* "Craft" the AVP query string... */
	/* It looks like: <0>time:/path */
	time(&nowtime);
	sprintf(scan, "<0>%.15s:%s", ctime(&nowtime)+4, scanpath);
	virge_debug(3, "[ scan_avp() ] string to send to AVP = [%s]", scan);

	/* Send the request - read response */
	/* Taken from AVP examples, of course :) */
 	if ((write(avp, scan, strlen(scan)+1)) == -1)
	{
		virge_debug(2, "[ scan_avp() ] failed to write to AVP");
		syslog(LOG_INFO,"FAILURE: Failed to write to AVPDaemon in scan_avp()");
		return(-1);
	}
	
	/* Here comes the response... */
	virge_debug(3, "[ scan_avp() ] reading response from AVP");

	read(avp, (char *) &resp, 2);
	exitcode = (resp & 0xcf);

	virge_debug(3, "[ scan_avp() ] response received and processed [%d]", exitcode);

	if (exitcode == 4)
	{
		int multiple_viruses = 0;
		
		/* Some flag - too lazy to figure that one out now... */
		if (resp & 0x0200)
		{
			if (read(avp, &msglen, 4) != 4)
				virge_debug(4, "[ scan_avp() ] failure reading some flag crap");
		}

		/* Read message (response) length */
		if (read(avp, &msglen, 4) != 4)
			syslog(LOG_INFO,"[ scan_avp() ] failed to read() 4 bytes (msglen)");

		response = (char *) malloc(msglen+1);
		memset(response, 0, sizeof(response));
		tempresp = response;
		
		while ( (msglen > 0) && ((readrecv = recv(avp, tempresp, msglen, 0)) != 0) )
		if (readrecv == -1) {
			syslog(LOG_INFO,"[ scan_avp() ] failed to recv() AVPDaemon message");
		}
		else {
			msglen -= readrecv;
			tempresp += readrecv;
		}

		if (strstr(response, "infected:"))
		{
			char *resp_line;
			char *v_name;

			if ((resp_line = strtok(response, "\n")))
			{
			    char *inf;
			    char *eol = strchr(resp_line, '\n');

			    if (eol)
					*eol = '\000';

			    inf = strstr(resp_line, "infected: ");
			    if (inf && strlen(inf) > 10)
				{
					char *sp;
					v_name = inf+10;

					/* Strip trailing space (after virus name) */
					sp = v_name + strlen(v_name)-1;
					
					if(*sp == ' ')
				    	*sp = '\000';

					VIRUS_NAME = strdup(v_name);

					multiple_viruses++;
			    }

				while ((resp_line = strtok(NULL, "\n")))
				{
					eol = strchr(resp_line, '\n');
					if (eol)
						*eol = '\000';
					
					inf = strstr(resp_line, "infected: ");
					if (inf && strlen(inf) > 10)
					{
						char *sp;
						v_name = inf + 10;

						sp = v_name + strlen(v_name)-1;
						if (*sp == ' ')
							*sp = '\000';

						if (strlen(VIRUS_NAME) < 1)
						{
							VIRUS_NAME = strdup(v_name);
						}
						else
						{
							VIRUS_NAME = realloc(VIRUS_NAME, strlen(VIRUS_NAME) + strlen(v_name) + 4);
							strncat(VIRUS_NAME, " + ", 3);
							strncat(VIRUS_NAME, v_name, strlen(v_name));
							strncat(VIRUS_NAME, "", 1);
						}

						multiple_viruses++;
					}
				}
			}
		}

		syslog(LOG_INFO,"[ scan_avp() ] Virus found: [%s]", VIRUS_NAME);
		virge_debug(1, "[ scan_avp() ] Whoa - got a virus [%s]", VIRUS_NAME);

		free(response);
	}

	if ((close(avp)) == -1)
	{
		syslog(LOG_INFO,"FAILURE: Failed to close socket to AVPDaemon in scan_avp()");
		virge_debug(2, "[ scan_avp() ] failed to close socket to AVP");
	}

	virge_debug(1, "[ scan_avp() ] AVP scan finished");
	return(exitcode);
}
