#include "virge.h"

int sophie_scanfile(const char *scanpath)
{
	int sophie_sock;
	int sophie_bread;
	struct sockaddr_un sophie_server;
	char sophie_buffer[V_BUFSIZE];
	char sophie_sockname[MAXPATHLEN];
	
	/* Create a socket */
	if ( (sophie_sock = socket(AF_UNIX, SOCK_STREAM, 0)) < 0) {
	    syslog(LOG_INFO,"FAILURE: Failed to create a socket in scan_sophie()");
	    virge_debug(2, "[ sophie_scanfile() ] failed to create socket");
	    return(90);
	}
	
	/* Check if socket name exists */
	if (V_SCAN_SOPHIE_SOCKET[0] == '\0') {
	    syslog(LOG_INFO,"FAILURE: V_SCAN_SOPHIE_SOCKET name not set");
	    virge_debug(2, "[ sophie_scanfile() ] FAILURE: V_SCAN_SOPHIE_SOCKET name not set");
	    return(91);
	}
	
	/* Copy the name into sophie_sockname */
	strncpy(sophie_sockname, V_SCAN_SOPHIE_SOCKET, sizeof(sophie_sockname)-1);
	
	/* Set the socket properties */
	sophie_server.sun_family = AF_UNIX;
	strncpy(sophie_server.sun_path, V_SCAN_SOPHIE_SOCKET, sizeof(sophie_server.sun_path)-1);
	virge_debug(3, "[ sophie_scanfile() ] V_SCAN_SOPHIE_SOCKET (%s) properties set", V_SCAN_SOPHIE_SOCKET);

	/* Connect */
	if (connect(sophie_sock, (struct sockaddr *) &sophie_server, sizeof(struct sockaddr_un)) < 0) {
	    syslog(LOG_INFO,"FAILURE: connect() to socket failed in scan_sophie()");
	    virge_debug(2, "[ sophie_scanfile() ] FAILURE: Could not connect to socket (%s)", V_SCAN_SOPHIE_SOCKET);
	    return(92);
	}

	/* Send name of path to send and \n to sophie */
	if ((write(sophie_sock, scanpath, strlen(scanpath)) < 0) || (write(sophie_sock, "\n", 1)) < 0)
	{
	    perror("write");
	    syslog(LOG_INFO,"FAILURE: write() to socket failed in scan_sophie() [tried to write: (%s)]", scanpath);
	    virge_debug(2, "[ sophie_scanfile() ] FAILURE: write() to socket failed [tried to write: (%s)]", scanpath);
	    return(93);
	}

	/* Read the response */
	memset(sophie_buffer, 0, sizeof(sophie_buffer));
	if ((sophie_bread = read(sophie_sock, sophie_buffer, sizeof(sophie_buffer))) > 0)
	{
	    char *eol = strchr(sophie_buffer,'\n');
	    char *vname = strchr(sophie_buffer,':');

	    if(eol)
		{
			/* if end of line, remove it */
			*eol = '\000';
	    }

	    if(vname)
		{
			/* Set the VIRUS_NAME */
			VIRUS_NAME = strdup(vname+1);
	    }

	    close(sophie_sock);
	    return(atoi(sophie_buffer));
	}

	syslog(LOG_INFO,"FAILURE: read() from socket failed in scan_sophie()");
	virge_debug(2, "[ sophie_scanfile() ] FAILURE: read() from socket failed");
	close(sophie_sock);
	return(94);
}

/* Send filepath(s) from scratch directory to Sophie daemon for scanning */
int sophie_scandir(const char *scan_dir)
{
    int sophie_resp;
    char scan_prepath[MAXPATHLEN];
    
    struct dirent *dir_contents;
    DIR *dir;
    
    /* Open the directory */
    if (!(dir = opendir(scan_dir)))
	{
		syslog(LOG_INFO,"FAILURE: opendir() failed for '%s'", scan_dir);
		return(0);
    }
    
    /* Browse through files, and scan them */
    for (dir_contents = readdir(dir) ; dir_contents != NULL ; dir_contents = readdir(dir))
	{
		if ( (strcmp(dir_contents->d_name, ".")) && (strcmp(dir_contents->d_name, "..")) )
		{
		    /* Add trailing slash if it's missing (for whatever reason) */
		    if (!(strcmp(scan_dir+(strlen(scan_dir)-1), "/")))
				snprintf(scan_prepath, sizeof(scan_prepath)-1, "%s%s", scan_dir, dir_contents->d_name);
		    else
				snprintf(scan_prepath, sizeof(scan_prepath)-1, "%s/%s", scan_dir, dir_contents->d_name);
	    
		    virge_debug(3, "[ sophie_scandir() ] Scanning file : [%s]", scan_prepath);
		    sophie_resp = sophie_scanfile(scan_prepath);
		    virge_debug(3, "[ sophie_scandir() ] Scan response = [%d]", sophie_resp);
	    
			if ((sophie_resp == -1) && (VIRUS_NAME[0] != '\0'))
			    event_log(LOG_ERROR, "Sophie returned -1 (%s) for file '%s' [%s => %s]", VIRUS_NAME, scan_prepath, MAIL_FROM, RCPT_TO);

			/* Don't stop scanning, unless we encountered a virus */
		    if(sophie_resp > 0)
				return(sophie_resp);
		}
    }
    
    closedir(dir);
    return(0);
}
