#include "virge.h"

int trophie_scanfile(const char *scanpath)
{
    int trophie_sock;
    int trophie_bread;
    struct sockaddr_un trophie_server;
    char trophie_buffer[V_BUFSIZE];
    char trophie_sockname[MAXPATHLEN];
	
    /* Create a socket */
    if ( (trophie_sock = socket(AF_UNIX, SOCK_STREAM, 0)) < 0)
	{
	    syslog(LOG_INFO,"FAILURE: Failed to create a socket in trophie_scanfile()");
	    virge_debug(2, "[ trophie_scanfile() ] failed to create socket [%s]", strerror(errno));
	    return(99);
	}
	
    /* Check if socket name exists */
    if (V_SCAN_TROPHIE_SOCKET[0] == '\0') {
	syslog(LOG_INFO,"FAILURE: V_SCAN_TROPHIE_SOCKET name not set");
	virge_debug(2, "[ trophie_scanfile() ] FAILURE: V_SCAN_TROPHIE_SOCKET name not set");
	return(99);
    }
	
    /* Copy the name into Trophie_sockname */
    strncpy(trophie_sockname, V_SCAN_TROPHIE_SOCKET, sizeof(trophie_sockname)-1);
	
    /* Set the socket properties */
    trophie_server.sun_family = AF_UNIX;
    strncpy(trophie_server.sun_path, V_SCAN_TROPHIE_SOCKET, sizeof(trophie_server.sun_path)-1);
    virge_debug(3, "[ strophie_scanfile() ] V_SCAN_TROPHIE_SOCKET (%s) properties set", V_SCAN_TROPHIE_SOCKET);

    /* Connect */
    if (connect(trophie_sock, (struct sockaddr *) &trophie_server, sizeof(struct sockaddr_un)) < 0)
	{
	    syslog(LOG_INFO,"FAILURE: connect() to socket failed in trophie_scanfile()");
	    virge_debug(2, "[ trophie_scanfile() ] FAILURE: Could not connect to socket (%s) [%s]", V_SCAN_TROPHIE_SOCKET, strerror(errno));
	    return(99);
	}

    /* Send a filename path to scan */
    if (write(trophie_sock, scanpath, strlen(scanpath)) < 0 ||
	write(trophie_sock, "\n", 1) < 1 ) { 

	    perror("write");
	    syslog(LOG_INFO,"FAILURE: write() to socket failed in trophie_scanfile() [tried to write: (%s)] [%s]", scanpath, strerror(errno));
	    virge_debug(2, "[ trophie_scanfile() ] FAILURE: write() to socket failed [tried to write: (%s) [%s]]", scanpath, strerror(errno));
	    return(99);
	}

    /* Read the response */
    memset(trophie_buffer, 0, sizeof(trophie_buffer));
    if ((trophie_bread = read(trophie_sock, trophie_buffer, sizeof(trophie_buffer)-1)) > 0) {
	char *eol = strchr(trophie_buffer, '\n');
	char *vname = index(trophie_buffer, ':');

	if(eol) *eol='\000';
	if(vname){
	    VIRUS_NAME = strdup(vname+1);
	}
/*	else{
	    VIRUS_NAME = "*** not provided by trophie ***";
	}
*/	close(trophie_sock);
	return(atoi(trophie_buffer));
    }
    else {
	syslog(LOG_INFO,"FAILURE: read() from socket failed in trophie_scanfile() [%s]",
	       strerror(errno));
	virge_debug(2, "[ trophie_scanfile() ] FAILURE: read() from socket failed [%s]",
		    strerror(errno));
	close(trophie_sock);
	return(99);
    }

    /* This couldn't be reached, I presume */
    close(trophie_sock);

}

/* Send filepath(s) from scratch directory to Trophie daemon for scanning */
int trophie_scandir(const char *scan_dir)
{
    int trophie_resp;
    char scan_prepath[MAXPATHLEN];

    struct dirent *dir_contents;
    DIR *dir;
	
    /* Open the directory */
    if (!(dir = opendir(scan_dir))) {
	syslog(LOG_INFO,"FAILURE: opendir() failed for '%s'", scan_dir);
	return(0);
    }

    /* Browse through files, and scan them */
    for (dir_contents = readdir(dir) ; dir_contents != NULL ; dir_contents = readdir(dir)) {
	if ( (strcmp(dir_contents->d_name, ".")) && (strcmp(dir_contents->d_name, "..")) )
	    {
		/* Add trailing slash if it's missing (for whatever reason) */
		if (!(strcmp(scan_dir+(strlen(scan_dir)-1), "/"))){
		    snprintf(scan_prepath, sizeof(scan_prepath)-1, "%s%s",
			     scan_dir, dir_contents->d_name);
		}
		else{
		    snprintf(scan_prepath, sizeof(scan_prepath)-1, "%s/%s",
			     scan_dir, dir_contents->d_name);
		}

		virge_debug(3, "[ trophie_scandir() ] Scanning file : [%s]", scan_prepath);
		trophie_resp = trophie_scanfile(scan_prepath);
		virge_debug(3, "[ trophie_scandir() ] Scan response = [%d]", trophie_resp);

		if (trophie_resp > 0)
			return(1);
	    }
    }
    closedir(dir);

    return(0);
}
