/****************************************************************
 *** virge.h
 ****************************************************************/

/*
 * Global #include file for Virge3.0rc3-clam system
 * (C) 2002 Simson L. Garfinkel, All Rights Reserved.
 * Parts (C) 2003 J.J.G. steegers, All Rights Reserved.
 *
 * Information in this file:
 * - Virge-specific defines
 *   - error codes and messages
 *   - compiled-in defaults.
 * - #include files used by all Virge modules.
 *   - config.h - created by autoconf.
 *   - other system includes
 *
 * 
 */

#include "config.h"
#include <time.h>
#include <sys/param.h>
#include <stdio.h>

#ifndef STDIO_H_DECLARES_VSNPRINTF
extern int vsnprintf(char *, size_t, const char *, va_list);
extern int snprintf(char *, size_t, char *,...);
#endif

#if (!defined(GRP_H_DECLARES_INITGROUPS)) && (!defined(UNISTD_H_DECLARES_INITGROUPS))
extern int initgroups(const char *, gid_t);
#endif


typedef char ***VLIST;			// a vlist is a pointer to a null-terminated array of strings
const char *vlist(VLIST list,int elem);	// return element #elem
VLIST vlist_alloc();		// initialize the list
void vlist_free(VLIST list);
int vlist_count(VLIST list);			// returns number of elements in a vlist
void vlist_append(VLIST list,const char *str); // append an element
const char *vlist_last(VLIST list);	// returns last element


/* compiled-in defaults */
#define V_DELIVERY_SLEEP 0		// seconds to sleep after each message is delivered

#define NOTIFY_VIRUS_FOUND	0
#define NOTIFY_BAD_ATTACHMENTS	1


/* VIRGE ERROR CODES */

#define VIRGE_VERSION	"3.04rc3"

#define ERR_REG_BADRPT		"Invalid use of repetition operators such as using `*' as the first character."
#define ERR_REG_BADBR		"Invalid use of back reference operator."
#define ERR_REG_EBRACE		"Un-matched brace interval operators."
#define ERR_REG_EBRACK		"Un-matched bracket list operators."
#define ERR_REG_ERANGE		"Invalid use of the range operator, eg. the ending point of the range occurs prior to the starting point."
#define ERR_REG_ECTYPE		"Unknown character class name."
#define ERR_REG_ECOLLATE	"Invalid collating element."
#define ERR_REG_EPAREN		"Un-matched parenthesis group operators."
#define ERR_REG_ESUBREG 	"Invalid back reference to a subexpression."
#define ERR_REG_EEND		"Non specific error. This is not defined by POSIX.2."
#define ERR_REG_EESCAPE 	"Trailing backslash."
#define ERR_REG_BADPAT		"Invalid use of pattern operators such as group or list"
#define ERR_REG_ESIZE		"Compiled regular expression requires a pattern buffer larger than 64Kb. This is not defined by POSIX.2."
#define ERR_REG_ESPACE		"The regex routines ran out of memory."

// places to check for the config
#define V_CONFIG_PATH "/etc/virge.conf:/etc/mail/virge.conf:/usr/local/etc/virge.conf:./virge.conf"


/* Global defines */
#define V_BUFSIZE	4096
#define V_LOGMSG	1024
#define V_ARGSIZE	256
#define V_EMAILSIZE	256
#define V_MSGSIZE	4096
#define V_MSGID 	1024

/* Command line options */
extern int CHECK_CONFIG_VERBOSE;
extern int USE_PROCMAIL;		// Use procmail to deliver to mailboxes?


/* Globals that are set by RFC processing */
extern int sections;
extern int needs_rewrite;
extern int attachCounter;
extern int contains_virus;		// 0 for no virus, 1 for virus

extern FILE *rewrite_file;		// the file that we rewrite to
extern FILE *input_file;		// where input file is cached

/* Globals that act like #defines, but which we have as variables
 * so that we can dynamically change our behavior.
 */

extern int DEBUG_OUTPUT;		// where we send debugging
extern int CMDLINE_DEBUG;
extern int DEBUG_LEVEL;
extern int CMDLINE_DEBUG_LEVEL;
extern int V_SCAN_AVP;
extern int V_SCAN_SOPHIE;
extern int V_SCAN_TROPHIE;
extern int V_SCAN_CLAMAV;
extern int V_DELIVER_LOADAVG;
extern int V_DEFER_LOADAVG;
extern int SAVE_ISOLATED;
extern long V_MAIL_SIZE;
extern int V_DEFER_ON_FAIL;

/* Delivery options */
extern int DELIVER_SMTP;		// deliver via SMTP proxy
extern char *SMTP_HOST;
extern int SMTP_PORT;			// which port

extern int DELIVER_PROCMAIL;		// deliver via proxmail

/* System configuration variables */

/* Virge lists that are dynamically loaded */
extern VLIST REMOVED;			// attachments that are removed
extern VLIST EXTENSIONS;		// extensions that are not allowed
extern VLIST ALLOW_USERS;		// users that are not scanned

/* Filename (if rewriting is required) */
extern char rewrite_filename[MAXPATHLEN];

/* Inter-message boundary */
extern char boundary[V_BUFSIZE];

/* Config file things */
extern char *VIRGE_DIR_MODE;
extern char *ISOLATED_FILE_MODE;

extern char *V_SCAN_SOPHIE_SOCKET;
extern char *V_SCAN_TROPHIE_SOCKET;
extern char *V_SCAN_CLAMAV_SOCKET;

extern char *V_DIR;
extern char *V_LOGDIR;
extern char *V_TEMPDIR;
extern char *V_ISODIR;
extern char *V_ETCDIR;
extern char *RUNAS_USER;
extern char *PROCMAIL;
extern char *PROCMAIL_ARGS;
extern char *SENDMAIL;
extern char *SENDMAIL_ARGS;
extern char *ADMIN;
extern char *VIRGE_FROM;

extern char *V_TEMPLATE_NOTIFY_SENDER_VIRUS;
extern char *V_TEMPLATE_NOTIFY_RCPT_VIRUS;
extern char *V_TEMPLATE_NOTIFY_SENDER_ATTACH;

/* The virge logfiles
 * Why does it need so many?
 */
extern char *LOG_VDEBUG;		// virge debug log
extern char *LOG_VIRGE;			// standard log
extern char *LOG_ERROR;			// virge errors
extern char *LOG_ACTION;		// virge actions
extern char *LOG_VIRUS;			// viruses found

extern char *V_CONFIG;			// the configuration file we used
extern char *V_EXT;
extern char *V_USERS;

extern char *V_MAILBODY;
extern char *V_PROGNAME;
extern char messageID[];

extern char *MAIL_FROM;
extern char *RCPT_TO;
extern VLIST RCPT_TOS;


extern int NOTIFY_SENDER_VIRUS;
extern int NOTIFY_SENDER_ATTACHMENT;
extern int NOTIFY_RCPT_VIRUS;
extern int NOTIFY_USE_HEADER_RCPT;
extern int INTERACTIVE;

/* Interesting things from the email message */
extern char	headers[V_BUFSIZE];
extern char	*NOTIFY_SUBJECT;	// message subject
extern char	*NOTIFY_DATE;		// message date
extern char	*NOTIFY_TO;		// message TO
extern char	*VIRUS_NAME;
extern unsigned int VIRGE_TIMEOUT;
extern time_t VIRGE_START_TIME;

extern int V_TEST;			// test mode? (-t option)

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <ctype.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <fcntl.h>
#include <errno.h>
#include <syslog.h>
#include <dirent.h>
#include <pwd.h>
#include <signal.h>
#include <string.h>
#include <rfc2045.h>
#include <rfc2047.h>
#include <regex.h>
#include <grp.h>

#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif

/* If the system doesn't understand O_NOFOLLOW, define a value */
#ifndef O_NOFOLLOW
#define O_NOFOLLOW     0400000
#endif

#ifdef SOLARIS
#include <sys/loadavg.h>
#endif

#ifdef linux
#define PROC_LOADAVG	"/proc/loadavg"
#endif

/* virge.c */
void usage(void);

/* virge_log.c */

/* virge_debug()
 * call for standard debugging output...
 */
void virge_debug(int debugLevel, char *debugMessage, ...); // standard debugging

/* event_log():
 * Log to a special logfile. Automatically calls virge_debug(1).
 */
int  event_log(char *logPath, char *logMessage, ...); // log to one of the Virge Logfiles

/* virge_file.c */
char *mkdir_isolate(char *isolateDir,int dirnamelen);
int copyFile(char *src, char *dst);
int isolate(int type, char *isoComment, char *isoFile, int isoNotify, char *isoNotifyMsg);
int  virge_mkdir(char *newdir);
int  check_directory(const char *checkDir, uid_t *uid);
void  demand_directory(const char *checkDir, const char *dirType);
char *get_date_dir(char *ddir);
void remove_tempdir(char *removeDir);
int file_exists(char *check_if_exists);
void get_headers(FILE *infile);
char *mystrcasestr(char *str_string, char *str_pattern);
int mystrncasecmp(char *str1, char *str2, int n);

/* smtp.c */
extern int SMTP_MODE;
int smtp_open_proxy(FILE *input_file);
int smtp_deliver(const char *filename);
void smtp_cleanup(int code);

/* run.c */
FILE *run_program(int mode, const char *program, const char *argsstr, ...);
int run_terminate();
/* List of modes. */
#define RUN_READ 0
#define RUN_WRITE 1
/* List of types of variables. */
#define RUN_STRING 0
#define RUN_VLIST 1

/* deliver.c */
int procmail_deliver(const char *mailFile, char *aParam);
FILE *virge_openmail(const char *to, const char *subject, const char *body); // create an outgoing message
int virge_closemail(FILE *fhan);

/* virge_attachments.c */
void print_regex_err(const char *regex_test, const char *regex_err_msg);
int check_extension_regex(char *regexCheckExtension);
void check_attachments(struct rfc2045 *p, struct rfc2045id *id, void *ptr);
void rewrite_attachments(struct rfc2045 *p, struct rfc2045id *id, void *ptr);
void notify_removed_attachments(FILE *out);

/* scan_sophie.c */
int sophie_scanfile(const char *scanpath);
int sophie_scandir(const char *scandir);

/* scan_trophie.c */
int trophie_scanfile(const char *scanpath);
int trophie_scandir(const char *scandir);

/* scan_avp.c */
int scan_avp(const char *scanpath);

/* scan_clam.c */
int scan_clam(const char *scanpath);
int clam_pingpong(struct sockaddr_un);

/* virge_config.h */
void load_extensions(void);
void load_allowusers(void);
int  config_set(char *confLine, char *confEntry, char *configData);
void load_virge_config(void);
void check_current_config(void);

/* rfcfuncs.c */
void rfc2045_error(const char *errmsg);
void do_print_structure(struct rfc2045 *p, struct rfc2045id *id, void *ptr);
int  decode_to_file(const char *p, size_t n, void *ptr);
char *tempname(const char *tempdir);
void do_print_section(struct rfc2045 *s, FILE *fp);
void notfound(const char *p);
char *get_suitable_filename(struct rfc2045 *r, const char *pfix, int ignore_filename);
void extract_file(struct rfc2045 *p, const char *filename, int argc, char **argv);
void extract_section(struct rfc2045 *top_rfcp, const char *mimesection,
const char *extract_filename, int argc, char **argv, void (*extract_func)(struct rfc2045 *, const char *, int, char **));

/* virge_loadavg.c */
int check_loadavg(void);

/* virge_notify.c */
int notify_sender(int notify_type);
int notify_rcpt(int notify_type);
