#include "virge.h"

/****************************************************************
 ** vlist manipulation routines
 ****************************************************************/

VLIST vlist_alloc()
{
    return calloc(1,sizeof(char *));
}

const char *vlist(VLIST list,int elem)
{
    return (*list)[elem];
}

void vlist_free(VLIST list)
{
    unsigned int i = 0;

    if (! *list)
	return;

    for (; (*list)[i]; i ++)
	free((*list)[i]);
    free(list);
}

int vlist_count(VLIST array)
{
    int i;

    if(array[0]==0) return 0;		/* never created */
    for(i=0;(*array)[i];i++){
	/* Not much to do here */
    }
    return i;	
}

const char *vlist_last(VLIST array)
{
    int last = vlist_count(array)-1;
    if(last>0) return (*array)[last];
    return 0;				/* no elements in array */
}

void vlist_append(VLIST array,const char *str)
{
    int len = vlist_count(array);
    (*array) = realloc((*array),sizeof(char *)*(len+2));
    if(*array==0){
	/* Out of memory; very bad */
	fprintf(stderr,"vlist_append: out of memory appending '%s' as element %d\n",str,len);
	exit(1);
    }
    (*array)[len] = strdup(str);
    if((*array)[len]==0){
	fprintf(stderr,"vlist_append: out of memory allocating %d byte string '%s'\n",strlen(str),str);
	exit(1);
    }

    (*array)[len+1] = 0;			/* continue null termination */
}


