#!/bin/sh
#  place patch and this script below the virge virge-3.04rc3 dir
# and run this script
# comment out the next line to activate this script
TEST="--dry-run"
# virge version
VVERS="3.04rc3"
# patch version
PVERS="0.3"
#

VIRGE="virge-${VVERS}"
PATCH="virge4clam-${VVERS}-${PVERS}.patch"

if [ ! -d ${VIRGE} ]  ; then
    echo "virge directory ${VIRGE} not found.."
    exit
else 
    echo "Will patch sources in directory ${VIRGE}.."
fi

if [ ! -f ${PATCH}  ] ; then
    echo "patchfile ${PATCH} not found.."
    exit
else 
    echo "Using patch file ${PATCH}.."
fi

if [  -f ${VIRGE}/${PATCH}  ] ; then
    echo "Virge alraedy patched!?"
    exit
fi
cd ${VIRGE}
echo "Executes: patch $TEST -p1 < ../${PATCH}"
patch $TEST -p1 < ../${PATCH}

if [ ! "$TEST" = "" ] ; then 
    echo "** This is a TEST run! **"
    echo "Comment out the variable TEST to activate this script!"
else
    mv ../${PATCH} .
    gzip ${PATCH} 
    gzip  ../${0}
    mv ../${0}.gz  .
    cd ..
    mv ${VIRGE} ${VIRGE}-clam-${PVERS}
    tar -czf ${VIRGE}-clam-${PVERS}.tar.gz ${VIRGE}-clam-${PVERS}
fi
